#include <iostream>
#include <cmath>
#include <vector>
#include <algorithm> // std::sort

using namespace std;

struct PolaznaTacka {
    int x, y;

    PolaznaTacka() {}

    PolaznaTacka(int _x, int _y) {
        x = _x;
        y = _y;
    }

    bool operator<(const PolaznaTacka& pt) {
        return x < pt.x || (x == pt.x && y < pt.y);
    }
};

int main() {

    int N;
    vector<int> x, y;

    cin >> N;

    vector<PolaznaTacka> polazna_tacka(N);
    int unos_x, unos_y;

    bool svi_y_jednaki = true;
    int prethodni_y;

    bool svi_x_jednaki = true;
    int prethodni_x;

    for (int i = 0; i < N; i++) {
        cin >> unos_x >> unos_y;
        polazna_tacka[i] = PolaznaTacka(unos_x, unos_y);

        if (i == 0) {
            prethodni_x = unos_x;
            prethodni_y = unos_y;
        } else { // i > 0
            if (svi_x_jednaki) {
                if (unos_x != prethodni_x) {
                    svi_x_jednaki = false;
                }
                prethodni_x = unos_x;
            }
            if (svi_y_jednaki) {
                if (unos_y != prethodni_y) {
                    svi_y_jednaki = false;
                }
                prethodni_y = unos_y;
            }
        }
    }

    // Ispis ulaza - zakomentarisati
    /*
    for (int i = 0; i < N; i++) {
        cout << (i + 1) << ". (" << polazna_tacka[i].x << ", " << polazna_tacka[i].y << ")" << endl;
    }
    */

    // Specijalni slucaj
    if (svi_x_jednaki || svi_y_jednaki) {
        cout << ((long)N * (N - 1) / 2);
        return 0;
    }

    // Sortiranje po uzlaznoj vrednosti koordinata X i Y
    sort(begin(polazna_tacka), end(polazna_tacka));

    int broj_pozdrava = 0;

    PolaznaTacka prethodna_tacka = polazna_tacka[0];
    PolaznaTacka naredna_tacka;
    vector<int> trkaci_prethodnih_tacaka_x = {polazna_tacka[0].x};
    vector<int> trkaci_prethodnih_tacaka_y = {polazna_tacka[0].y};
    int pomeraj;
    for (int i = 1; i < N; i++) {
        // cout << (i + 1) << ". (" << polazna_tacka[i].x << ", " << polazna_tacka[i].y << ")" << endl;

        naredna_tacka = polazna_tacka[i];

        pomeraj = naredna_tacka.x - prethodna_tacka.x;
        for (int& koordinata : trkaci_prethodnih_tacaka_x) koordinata += pomeraj;
        for (int& koordinata : trkaci_prethodnih_tacaka_y) koordinata += pomeraj;

        broj_pozdrava += count(trkaci_prethodnih_tacaka_x.begin(), trkaci_prethodnih_tacaka_x.end(), naredna_tacka.x);
        broj_pozdrava += count(trkaci_prethodnih_tacaka_y.begin(), trkaci_prethodnih_tacaka_y.end(), naredna_tacka.y);

        prethodna_tacka = naredna_tacka;
        trkaci_prethodnih_tacaka_x.emplace_back(naredna_tacka.x);
        trkaci_prethodnih_tacaka_x.emplace_back(naredna_tacka.y);
    }

    cout << broj_pozdrava;

    return 0;
}